/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.events;

import com.tristankechlo.livingthings.config.GeneralConfig;
import com.tristankechlo.livingthings.config.entity.AncientBlazeConfig;
import com.tristankechlo.livingthings.config.entity.BabyEnderDragonConfig;
import com.tristankechlo.livingthings.entity.AncientBlazeEntity;
import com.tristankechlo.livingthings.entity.BabyEnderDragonEntity;
import com.tristankechlo.livingthings.init.ModEntityTypes;
import com.tristankechlo.livingthings.init.ModItems;
import com.tristankechlo.livingthings.util.LivingThingsTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public final class BlockEvents {
    public static void onBlockBreak(LevelAccessor world, Player player, BlockPos pos, BlockState state) {
        int silktouchLevel;
        if (!GeneralConfig.get().doBananaDrops.get().booleanValue()) {
            return;
        }
        if (world == null || state == null || player == null || pos == null) {
            return;
        }
        if (world.m_5776_() || player.m_5833_() || player.m_7500_()) {
            return;
        }
        if (!state.m_204336_(LivingThingsTags.DROPS_BANANAS)) {
            return;
        }
        ItemStack stack = player.m_21205_();
        if (!stack.m_41619_() && ((silktouchLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)stack)) > 0 || stack.m_41720_() instanceof ShearsItem)) {
            return;
        }
        double dropChance = (Double)GeneralConfig.get().bananaDropChance.get() / 100.0;
        if (world.m_213780_().m_188500_() < dropChance) {
            ItemStack loot = new ItemStack((ItemLike)ModItems.BANANA.get());
            ItemEntity entity = new ItemEntity((Level)world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), loot);
            world.m_7967_((Entity)entity);
        }
    }

    public static InteractionResult onBlockPlace(LevelAccessor world, Player player, BlockPos pos, BlockState placedBlock) {
        if (world.m_5776_() || player.m_5833_()) {
            return InteractionResult.PASS;
        }
        if (!placedBlock.m_60713_(Blocks.f_50144_) && !placedBlock.m_60713_(Blocks.f_50260_)) {
            return InteractionResult.PASS;
        }
        BlockState blockBelow = world.m_8055_(pos.m_7495_());
        BlockState blockBelow2 = world.m_8055_(pos.m_6625_(2));
        if (placedBlock.m_60713_(Blocks.f_50144_) && blockBelow.m_60713_(Blocks.f_50141_) && blockBelow2.m_60713_(Blocks.f_50141_)) {
            if (!AncientBlazeConfig.canSpawn()) {
                return InteractionResult.PASS;
            }
            world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
            world.m_7731_(pos.m_7495_(), Blocks.f_50016_.m_49966_(), 3);
            world.m_7731_(pos.m_6625_(2), Blocks.f_50016_.m_49966_(), 3);
            AncientBlazeEntity blaze = (AncientBlazeEntity)ModEntityTypes.ANCIENT_BLAZE.get().m_20615_((Level)world);
            blaze.setInvulnerableTime(AncientBlazeConfig.chargingTime());
            blaze.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_6625_(2).m_123342_() + 0.2, (double)pos.m_123343_() + 0.5);
            world.m_7967_((Entity)blaze);
            return InteractionResult.SUCCESS;
        }
        if (placedBlock.m_60713_(Blocks.f_50260_) && blockBelow.m_60713_(Blocks.f_50441_) && blockBelow.m_61143_((Property)RotatedPillarBlock.f_55923_) == Direction.Axis.Y) {
            if (world.m_6042_().f_63856_()) {
                return InteractionResult.PASS;
            }
            if (!BabyEnderDragonConfig.canSpawn()) {
                return InteractionResult.PASS;
            }
            world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
            int count = 10;
            double radius = 6.0;
            for (int i = 0; i < 10; ++i) {
                LightningBolt bolt = (LightningBolt)EntityType.f_20465_.m_20615_((Level)world);
                double x = (double)pos.m_123341_() + 6.0 * (double)Mth.m_14089_((float)((float)(i * 2) * (float)Math.PI / 10.0f));
                double z = (double)pos.m_123343_() + 6.0 * (double)Mth.m_14031_((float)((float)(i * 2) * (float)Math.PI / 10.0f));
                double y = pos.m_7495_().m_123342_();
                bolt.m_6034_(x, y, z);
                world.m_7967_((Entity)bolt);
            }
            BabyEnderDragonEntity dragon = (BabyEnderDragonEntity)ModEntityTypes.BABY_ENDER_DRAGON.get().m_20615_((Level)world);
            dragon.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.1, (double)pos.m_123343_() + 0.5);
            world.m_7967_((Entity)dragon);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

